<?php 
session_start();
require_once 'config.php';

// Fetch gallery images from database
$gallery_images = array();
$query = "SELECT id, title, description, image_url, category FROM gallery WHERE status = 'active' ORDER BY created_at DESC";
$result = $conn->query($query);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $gallery_images[] = $row;
    }
}

// If no database images, use default images as fallback
if (empty($gallery_images)) {
    $gallery_images = array(
        array('id' => 1, 'title' => 'Bed & Mattress Care', 'description' => 'Deep Cleaning', 'image_url' => 'assets/img/gallery/gallery-img-3-1.jpg', 'category' => 'residential'),
        array('id' => 2, 'title' => 'Hygienic Kitchen Cleaning', 'description' => 'Kitchen Care', 'image_url' => 'assets/img/gallery/gallery-img-3-4.jpg', 'category' => 'kitchen'),
        array('id' => 3, 'title' => 'Bathroom Deep Sanitization', 'description' => 'Sanitization', 'image_url' => 'assets/img/gallery/gallery-img-3-7.jpg', 'category' => 'bathroom'),
        array('id' => 4, 'title' => 'Living Room Cleaning', 'description' => 'Residential', 'image_url' => 'assets/img/gallery/gallery-img-3-2.jpg', 'category' => 'residential'),
        array('id' => 5, 'title' => 'Office Cleaning Service', 'description' => 'Commercial', 'image_url' => 'assets/img/gallery/gallery-img-3-5.jpg', 'category' => 'commercial'),
        array('id' => 6, 'title' => 'Polished Floor Cleaning', 'description' => 'Floor Care', 'image_url' => 'assets/img/gallery/gallery-img-3-9.jpg', 'category' => 'floor'),
    );
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Portfolio - Cleaning Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link
        href="../../css2-2?family=Fuzzy+Bubbles:wght@400;700&family=Poppins:wght@400;500;600;700;800&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>

<body>
    <!-- <div class="preloader"><button class="vs-btn preloaderCls">Cancel Preloader</button>
        <div class="preloader-inner"><img src="assets/img/logo.svg" alt="logo"><span class="loader"></span></div>
    </div> -->
    <?php include 'header.php'; ?>
    <div class="breadcumb-wrapper " data-bg-src="assets/img/breadcumb/breadcumb-bg.png">
            <div class="container z-index-common">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title">Our Gallery</h1>
                </div>
                <div class="breadcumb-menu-wrap">
                    <ul class="breadcumb-menu">
                        <li><a href="index.php">Home</a></li>
                        <li>our gallery</li>
                    </ul>
                </div>
            </div>
        </div>
    
        <section class="portfolio-glass space">
            <style>
                /* ===============================
   GLASS PORTFOLIO
================================ */

.portfolio-glass {
    background: linear-gradient(135deg, #e3f2fd, #f9fbff);
}

.glass-portfolio-card {
    background: rgba(255,255,255,0.35);
    backdrop-filter: blur(14px);
    -webkit-backdrop-filter: blur(14px);
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 15px 40px rgba(0,0,0,0.12);
    transition: transform 0.4s ease;
}

.glass-portfolio-card:hover {
    transform: translateY(-8px);
}

.glass-img {
    position: relative;
    overflow: hidden;
}

.glass-img img {
    width: 100%;
    height: 260px;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.glass-portfolio-card:hover img {
    transform: scale(1.1);
}

/* Overlay */
.glass-overlay {
    position: absolute;
    inset: 0;
    background: rgba(30,136,229,0.6);
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: 0.4s ease;
}

.glass-portfolio-card:hover .glass-overlay {
    opacity: 1;
}

.glass-overlay a {
    width: 55px;
    height: 55px;
    background: #fff;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #1e88e5;
    font-size: 20px;
}

/* Content */
.glass-content {
    padding: 18px 20px;
    text-align: center;
}

.glass-content span {
    font-size: 13px;
    color: #555;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.glass-content h3 {
    font-size: 18px;
    margin-top: 6px;
    font-weight: 600;
}

/* Pagination */
.glass-pagination a,
.glass-pagination span {
    display: inline-block;
    margin: 0 6px;
    padding: 10px 16px;
    border-radius: 30px;
    background: rgba(255,255,255,0.5);
    color: #333;
    font-size: 14px;
}

.glass-pagination a.active {
    background: #1e88e5;
    color: #fff;
}

/* Responsive */
@media (max-width: 991px) {
    .glass-img img {
        height: 230px;
    }
}

@media (max-width: 576px) {
    .glass-img img {
        height: 200px;
    }
}

            </style>
        <div class="container">

        <!-- Section Title -->
        <div class="row justify-content-center mb-40">
            <div class="col-lg-6 text-center">
                <span class="sec-subtitle">OUR WORK</span>
                <h2 class="sec-title">Cleaning Project Gallery</h2>
            </div>
        </div>

        <!-- Portfolio Grid - Dynamic from Database -->
        <div class="row g-4">

            <?php foreach ($gallery_images as $image): ?>
            <!-- Item -->
            <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12">
                <div class="glass-portfolio-card">
                    <div class="glass-img">
                        <img src="<?php echo htmlspecialchars($image['image_url']); ?>" alt="<?php echo htmlspecialchars($image['title']); ?>">
                        <div class="glass-overlay">
                            <a href="javascript:void(0)" class="popup-gallery-btn" data-image="<?php echo htmlspecialchars($image['image_url']); ?>" data-title="<?php echo htmlspecialchars($image['title']); ?>" data-description="<?php echo htmlspecialchars($image['description']); ?>">
                                <i class="fa-solid fa-expand"></i>
                            </a>
                        </div>
                    </div>
                    <div class="glass-content">
                        <span><?php echo htmlspecialchars($image['description']); ?></span>
                        <h3><?php echo htmlspecialchars($image['title']); ?></h3>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>

        </div>

        
    </div>
</section>

<!-- Modal Popup for Gallery Images -->
<div class="modal fade" id="galleryModal" tabindex="-1" aria-labelledby="galleryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content gallery-modal-content">
            <button type="button" class="btn-close gallery-close-btn" data-bs-dismiss="modal" aria-label="Close"></button>
            <div class="modal-body gallery-modal-body-only-image">
                <div class="gallery-image-wrapper">
                    <img id="galleryImage" src="" alt="Gallery Image" class="img-fluid">
                </div>
                <button type="button" class="gallery-nav-btn gallery-prev-btn" id="galleryPrevBtn">
                    <i class="fa-solid fa-chevron-left"></i>
                </button>
                <button type="button" class="gallery-nav-btn gallery-next-btn" id="galleryNextBtn">
                    <i class="fa-solid fa-chevron-right"></i>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Custom Modal Styles -->
<style>
    .gallery-modal-content {
        border: none;
        background: rgba(0, 0, 0, 0.95);
        padding: 0;
    }

    .gallery-close-btn {
        position: absolute;
        top: 20px;
        right: 20px;
        z-index: 1000;
        background: rgba(255, 255, 255, 0.9);
        border: none;
        color: #000;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0;
        transition: all 0.3s ease;
    }

    .gallery-close-btn:hover {
        background: #fff;
        transform: scale(1.1);
    }

    .gallery-modal-body-only-image {
        padding: 0;
        position: relative;
        background: #000;
    }

    .gallery-image-wrapper {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        max-height: 90vh;
        overflow: hidden;
    }

    .gallery-modal-body-only-image img {
        max-width: 100%;
        max-height: 85vh;
        object-fit: contain;
        display: block;
    }

    .gallery-nav-btn {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        background: rgba(255, 255, 255, 0.85);
        border: none;
        color: #000;
        width: 50px;
        height: 50px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
        z-index: 999;
        font-size: 20px;
    }

    .gallery-nav-btn:hover {
        background: #fff;
        transform: translateY(-50%) scale(1.1);
    }

    .gallery-prev-btn {
        left: 20px;
    }

    .gallery-next-btn {
        right: 20px;
    }

    .popup-gallery-btn {
        transition: all 0.3s ease;
    }

    .popup-gallery-btn:hover {
        transform: scale(1.1);
    }

    .modal-backdrop.show {
        backdrop-filter: blur(5px);
        background-color: rgba(0, 0, 0, 0.7);
    }

    @media (max-width: 768px) {
        .gallery-nav-btn {
            width: 40px;
            height: 40px;
            font-size: 16px;
        }

        .gallery-close-btn {
            width: 35px;
            height: 35px;
        }
    }
</style>
    <?php include 'footer.php'; ?>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/gsap-scroll-to-plugin.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>

    <!-- Gallery Modal Popup Script with Navigation -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const galleryButtons = document.querySelectorAll('.popup-gallery-btn');
            const galleryModal = new bootstrap.Modal(document.getElementById('galleryModal'));
            let currentImageIndex = 0;
            let galleryImages = [];
            
            // Populate gallery images array
            galleryButtons.forEach((button, index) => {
                galleryImages.push({
                    url: button.getAttribute('data-image'),
                    title: button.getAttribute('data-title'),
                    description: button.getAttribute('data-description'),
                    element: button
                });
            });
            
            // Handle gallery image clicks for modal popup
            galleryButtons.forEach((button, index) => {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    currentImageIndex = index;
                    openGalleryModal(currentImageIndex);
                });
            });
            
            // Open gallery modal at specific index
            function openGalleryModal(index) {
                if (index < 0 || index >= galleryImages.length) return;
                
                currentImageIndex = index;
                const image = galleryImages[index];
                document.getElementById('galleryImage').src = image.url;
                galleryModal.show();
            }
            
            // Next button functionality
            document.getElementById('galleryNextBtn').addEventListener('click', function() {
                let nextIndex = currentImageIndex + 1;
                if (nextIndex >= galleryImages.length) {
                    nextIndex = 0; // Loop back to first image
                }
                openGalleryModal(nextIndex);
            });
            
            // Previous button functionality
            document.getElementById('galleryPrevBtn').addEventListener('click', function() {
                let prevIndex = currentImageIndex - 1;
                if (prevIndex < 0) {
                    prevIndex = galleryImages.length - 1; // Loop to last image
                }
                openGalleryModal(prevIndex);
            });
            
            // Keyboard navigation
            document.addEventListener('keydown', function(e) {
                const modal = document.getElementById('galleryModal');
                if (modal.classList.contains('show')) {
                    if (e.key === 'ArrowRight') {
                        document.getElementById('galleryNextBtn').click();
                    } else if (e.key === 'ArrowLeft') {
                        document.getElementById('galleryPrevBtn').click();
                    }
                }
            });
        });
    </script>
</body>

</html>